'' /////////////////////////////////////////////////////////////////////////////
'' Graphics Renderer for Defender Remake
'' (C) Steve Waddicor
'' //////////////////////////////////////////////////////////////////////////////

'lines 24 + 2 braces + 2 dividers + 192 playfield = 220

OBJ
    g      : "sw_df_globals_005"

CON
    TERRAIN_COLOR                 = $6c

    SCREEN_WIDTH                  = 176/2
    SCREEN_WIDTH_IN_FRAMES        = SCREEN_WIDTH/4

VAR
    long  cog
    long  renderer_ptr_block

PUB start(renderer_ptr)

'' Start renderer - starts a cog
'' returns false if no cog available

    renderer_ptr_block := renderer_ptr
    coginit(3,@entry,renderer_ptr)

PUB stop
    cogstop(3)

DAT

'******************************
'* Assembly language renderer *
'******************************

                        org
'
'
' Entry
'
entry
'                        or     dira,#1
                        rdlong  rend_cog_number,PAR
                        mov     current_line,rend_cog_number  'start rendering from the top

do_frame                'Load parameters
                        mov     r0,PAR
                        movd    :load_dest,#renderer_params+1
                        mov     count,#g#PARAM_COUNT-1 + g#NUMBER_OF_SPRITES + g#NUMBER_OF_SPRITES + g#NUMBER_OF_LASER_SHOTS + g#NUMBER_OF_COLORS + g#NUMBER_OF_BULLETS
:load                   add     r0,#4
                        '       ___
:load_dest              rdlong  0-0,r0
                        '       ^^^ iterates through renderer_params array.
                        add     :load_dest,inc_dest
                        djnz    count,#:load

do_line                 ' Draw a single scan line
                        mov     mix1,black
                        cmp     current_line,#g#DIVIDER wz,wc
              if_b      jmp     #:after_colour_picked
                        mov     mix1,status_color
:after_colour_picked
                        mov     mix2,mix1

                        movd    :scan_line_store,#cog_scanline_buffer
                        mov     p,#SCREEN_WIDTH_IN_FRAMES
:do_long
:scan_line_store        mov     0-0,mix2    'dest starts at cog_scanline_buffer
                        add     :scan_line_store,inc_dest 'self-modify dest
                        mov     mix2,mix1
                        djnz    p,#:do_long

                        cmp     current_line,#0 wz,wc
              if_ne     jmp     #:not_line_0

                        movd    :top_loop,#cog_scanline_buffer+6
                        mov     p,#9
:top_loop               mov     0-0,status_color    'dest starts at cog_scanline_buffer
                        add     :top_loop,inc_dest 'self-modify dest
'                        mov     mix2,mix1
                        djnz    p,#:top_loop

                        mov     cog_scanline_buffer+10,white_sl
                        mov     cog_scanline_buffer+11,white_sr
:not_line_0             cmp     current_line,#1 wz,wc
              if_e      mov     cog_scanline_buffer+10,white_l
              if_e      mov     cog_scanline_buffer+11,white_r
                        cmp     current_line,#g#DIVIDER-1 wz,wc
              if_e      mov     cog_scanline_buffer+10,white_l
              if_e      mov     cog_scanline_buffer+11,white_r
                        cmp     current_line,#g#DIVIDER wz,wc
              if_e      mov     cog_scanline_buffer+10,white_sl
              if_e      mov     cog_scanline_buffer+11,white_sr
              if_ae     jmp     #wait_for_the_request                           'no output on divider lines
                        mov     cog_scanline_buffer+6,status_color_r
                        mov     cog_scanline_buffer+15,status_color_l

                        'draw smart bombs
                        mov     r0,#g#DIVIDER-1
                        sub     r0,current_line
                        mov     r1,r0
                        shr     r0,#2
                        cmp     r0,#3 wz,wc
            if_b        and     r1,#%11
            if_b        add     r1,#smartbomb_def
            if_b        movs    :load_smart_bomb1,r1
                        nop
:load_smart_bomb1
            if_b        mov     cog_scanline_buffer+5,0-0

                        'draw score
                        cmp     current_line,#3 wz,wc
            if_b        jmp     #status_area
                        cmp     current_line,#10 wz,wc
            if_ae       jmp     #status_area
                        rol     rend_bcd_score,#8

                        mov     r0,current_line
                        sub     r0,#3
                        shl     r0,#2

                        mov     r2,rend_palette_1
                        mov     r3,r2
                        rol     r2,#8
                        or      r3,r2
                        rol     r2,#8
                        or      r3,r2
                        rol     r2,#8
                        or      r3,r2
                        mov     mix1,r3
                        mov     mix2,#0

                        movd    :dest1,#cog_scanline_buffer
                        movd    :dest2,#cog_scanline_buffer
                        mov     count,#6
:digit_loop
                        rol     rend_bcd_score,#4
                        mov     mix1,r3
                        mov     tile_number,rend_bcd_score
                        and     tile_number,#%1111
                        or      mix2,tile_number wz
            if_nz       shl     tile_number,#5                                  '8 lines per character, 4 bytes per line
            if_nz       add     tile_number,r0
            if_nz       add     tile_number,rend_character_table_ptr
            if_nz       rdlong  r1,tile_number

:dest1      if_nz       andn    0-0,r1
            if_nz       and     mix1,r1
:dest2      if_nz       or      0-0,mix1

                        add     :dest1,inc_dest
                        add     :dest2,inc_dest
                        djnz    count,#:digit_loop

status_area
                        ' Render sprites
                        mov     this_sprite,#rend_sprites_loc 'first sprites in array are drawn first
                        mov     this_sprite_tile,#rend_sprites_tile 'first sprites in array are drawn first
'                        mov     outa,#0
status_sprite_loop
                        ' Verification: if the TV is already asking for this scanline or more
                        ' then panic, go to red alert with the debug LED and skip straight to TV output.
                        ' If the LED does light you need to consider optimising or allocating more
                        ' rendering cogs
'                        call    #checktv
'        if_ae           mov     outa,#1
'        if_ae           jmp     #start_tv_copy

                        'get the sprite attibutes in sprite_attr which we'll use for the rest of the routine
                        movs    :sprite_attr_load,this_sprite
                        nop
:sprite_attr_load       mov     sprite_attr,0-0 wc
                        ' get the tile number and explode count
                        movs    :sprite_tile_load,this_sprite_tile              ' separated from target by one instruction

                        'don't draw it if it has the invisible flag
              if_c      jmp     #next_status_sprite

:sprite_tile_load       mov     tile_number,0-0                                 ' ........_..EEEEEE_........_TTTTTTTT
                        mov     r0,tile_number                                  ' If it's exploding, don't draw on scanner
                        shr     r0,#16
                        test    r0,#$FF wz
              if_nz     jmp     #next_status_sprite
                        and     tile_number,#$FF

                        'optimisation for completed screen.  If no terrain, don't display humanoids.
                        cmp     tile_number,#g#TILE_BONUS_5 wz,wc
            if_ae       jmp     #next_status_sprite
                        cmp     rend_terrain_color,#$02 wz
              if_e      cmp     tile_number,#3 wz
              if_e      jmp     #next_status_sprite

                        mov     sprite_x,sprite_attr                            ' '%i.YYYYYY_YYyyyyyy_XXXXXXXX_XXxxxxxx (negative = invisible
                        shr     sprite_x,#6                                     'shift 6 for fixed point,
                        sub     sprite_x,rend_side_scroll
                        add     sprite_x,#428                                   'centre taking into account 0 = screen left edge
                        shr     sprite_x,#5                                     '8 to scale for long range scan pixel.

                         ' find the y-span and reject if current-line isn't in it.
                        mov     draw_y,sprite_attr                                  'draw_y=sprite-y
                        shr     draw_y,#25                                      '22 to extract y.  3 to scale.
                        add     draw_y,#2

                        cmp     draw_y,current_line wz,wc
                        add     draw_y,#1
              if_a      jmp     #next_status_sprite
              if_b      jmp     #:check_bottom_pixel

                        'set color for top pixel
                        mov     r2,rend_palette_0
                        cmp     tile_number,#g#TILE_SHIP_RIGHT wc,wz
              if_be     mov     r2,rend_palette_9
                        cmp     tile_number,#g#TILE_LANDER wc,wz
              if_e      mov     r2,rend_palette_4
                        cmp     tile_number,#g#TILE_HUMANOID_LEFT wc,wz
              if_e      mov     r2,rend_palette_6
                        cmp     tile_number,#g#TILE_HUMANOID_RIGHT wc,wz
              if_e      mov     r2,rend_palette_6
                        cmp     tile_number,#g#TILE_MUTANT wc,wz
              if_e      mov     r2,rend_palette_12
                        cmp     tile_number,#g#TILE_BOMBER wc,wz
              if_e      mov     r2,rend_palette_8
                        cmp     tile_number,#g#TILE_POD wc,wz
              if_e      mov     r2,rend_palette_10
                        cmp     tile_number,#g#TILE_SWARMER wc,wz
              if_e      mov     r2,rend_palette_2
                        cmp     tile_number,#g#TILE_BAITER wc,wz
              if_e      mov     r2,rend_palette_3
                        jmp     #:color_set

:check_bottom_pixel     cmp     draw_y,current_line wz,wc
              if_b      jmp     #next_status_sprite

                        'set color for bottom pixel
                        mov     r2,rend_palette_0
                        cmp     tile_number,#g#TILE_SHIP_RIGHT wc,wz
              if_be     mov     r2,rend_palette_9
                        cmp     tile_number,#g#TILE_LANDER wc,wz
              if_e      mov     r2,rend_palette_3
                        cmp     tile_number,#g#TILE_HUMANOID_LEFT wc,wz
              if_e      mov     r2,rend_palette_6
                        cmp     tile_number,#g#TILE_HUMANOID_RIGHT wc,wz
              if_e      mov     r2,rend_palette_6
                        cmp     tile_number,#g#TILE_MUTANT wc,wz
              if_e      mov     r2,rend_palette_3
                        cmp     tile_number,#g#TILE_BOMBER wc,wz
              if_e      mov     r2,rend_palette_8
                        cmp     tile_number,#g#TILE_POD wc,wz
              if_e      mov     r2,rend_palette_10
                        cmp     tile_number,#g#TILE_SWARMER wc,wz
              if_e      mov     r2,rend_palette_2
                        cmp     tile_number,#g#TILE_BAITER wc,wz
              if_e      mov     r2,rend_palette_3

                        'calculate start address in scan line buffer
:color_set              mov     r0,sprite_x
                        shr     r0,#2                                           'div 4 for pixels in a byte

                        and     r0,#%111                                       'long range scan is 16 longs wide
                        mov     cog_dest,#cog_scanline_buffer+7                '(52+64+52)
                        adds    cog_dest,r0

                        mov     r1,top_three_bytes

                        'calculate where the sprite stars within a frame
                        and     sprite_x,#%0000_0011 wz
              if_z      jmp     #:past_mask_loop
:mask_loop              rol     r1,#8
                        rol     r2,#8
                        djnz    sprite_x,#:mask_loop
:past_mask_loop
                        movs    :maskit,#r1
                        movd    :maskit,cog_dest
                        movd    :drawit,cog_dest

:maskit                 and     0-0,0-0
:drawit                 or      0-0,r2

next_status_sprite      add     this_sprite,#1
                        add     this_sprite_tile,#1
                        cmp     this_sprite,#rend_sprites_end wz
              if_ne     jmp     #status_sprite_loop

'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

                        ' We've finished rendering the line and we didn't have a hissy fit panic.
                        ' We need to wait here for the line we just prepared to be requested by the TV driver
wait_for_the_request
                        call    #checktv
              if_b      jmp     #wait_for_the_request

                        ' Our line has been requested so copy it to hub scan line buffer
start_tv_copy           movs    :nextcopy, #cog_scanline_buffer
                        mov     r0, rend_scanline_buffer
                        mov     count, #SCREEN_WIDTH_IN_FRAMES              ' length of visible scanline buffer in longs
:nextcopy               mov     r1,cog_scanline_buffer
                        add     :nextcopy, #1
                        wrlong  r1, r0
                        add     r0, #4
                        djnz    count, #:nextcopy

                        ' We've handed over the scanline to the TV driver, so do another.
allocate_next_job       add     current_line,rend_scanner_cog_count 'we only do every Nth line
                        ' Degrade gracefully when there's too much work to do.
                        call    #checktv
              if_ae     jmp     #allocate_next_job
                       ' Wrap around.
                        cmp     current_line,#g#DIVIDER+2 wz,wc
              if_b      jmp     #do_line
                        sub     current_line,#g#DIVIDER+2
                        jmp     #do_frame


'-------------------------------------------------------------------
checktv                 ' Tf we're currently rendering a low numbered line when a high one is being requested
                        ' then that's OK because we wrapped around.



                        rdlong  scanline_req,rend_scanline_req_adr
                        cmp     scanline_req,#g#DIVIDER+2-8 wc,wz
              if_be     jmp     #:checkit
                        cmp     current_line,#8 wc,wz
              if_be     cmp     scanline_req, current_line wz
                        'b = normal
                        'z = doit
                        'a = err
              if_be     jmp     #checktv_ret

:checkit                cmp     scanline_req, current_line wz, wc    'set carry if request is less than current.
                        'b = normal
                        'z = doit
                        'a = err

                        ' At this point, we could skip drawing sprites or something like that and go
                        ' straight to image output and still stay synced with the tv driver
                        ' We must be quick though!
                        'jmp #start_tv_copy
checktv_ret             ret
'-------------------------------------------------------------------

' Initialized data
inc_dest                long    1 << 9 << 0
black                   long    $02020202
white_sl                long    $0606060c
white_sr                long    $0c060606
white_l                 long    $02020602
white_r                 long    $02060202
status_color            long    $0c_0c_0c_0c
status_color_l          long    $02_02_02_0c
status_color_r          long    $0c_02_02_02
reverse                 long    $100_0000

' New for Defender
world_width_mask        long    %11_1111_1111
long_word_mask          long    $FFFF_FFFC
terrain_width           long    1024
x_pixel_inc             long    1<<30

offset0mask             long    $FFFF0000

offset1mask             long    $FF0000FF
offset2mask             long    $0000FFFF

sign_extend             'long    $FFFFFF00 same as next value
top_three_bytes         'long    $FFFFFF00 same as next value
offset3mask2            long    $FFFFFF00

offset3mask1            long    $00FFFFFF

smartbomb_def           long    $02020202
                        long    $02050405
                        long    $d8060606
                        long    $02050405

DAT 'Uninitiaised data - always keep it at the end of file to avoid nasty gotcha with RES.

' Parameter buffer
renderer_params
rend_cog_number         res     1
rend_playfield_cog_count res    1
rend_scanner_cog_count  res     1
rend_scanline_req_adr   res     1
rend_sprite_table_ptr   res     1
rend_character_table_ptr res    1
rend_laser_def_ptr      res     1
rend_color_table_ptr    res     1
rend_tile_map_ptr       res     1
rend_scanline_buffer    res     1
rend_terrain_ptr        res     1
rend_terrain_color      res     1
rend_side_scroll        res     1
rend_bcd_score          res     1                       'score in binary coded decimal
rend_sprites_loc        res     g#NUMBER_OF_SPRITES
rend_sprites_end
rend_sprites_tile       res     g#NUMBER_OF_SPRITES
rend_lasers             res     g#NUMBER_OF_LASER_SHOTS
rend_bullets            res     g#NUMBER_OF_BULLETS
rend_palette_0          res     1
rend_palette_1          res     1
rend_palette_2          res     1
rend_palette_3          res     1
rend_palette_4          res     1
rend_palette_5          res     1
rend_palette_6          res     1
rend_palette_7          res     1
rend_palette_8          res     1
rend_palette_9          res     1
rend_palette_10         res     1
rend_palette_11         res     1
rend_palette_12         res     1
rend_palette_13         res     1
rend_palette_14         res     1
rend_palette_15         res     1

' End of parameter buffer

' Cog scanline buffer = 292 pixels, 8 bits per pixel = 2336 bits = 292 bytes = 73 longs
'scratch1                res     1
cog_scanline_buffer     res     SCREEN_WIDTH_IN_FRAMES
end_of_cog_scanline_buffer
'scratch2                res     1
' End of scanline buffer

count                   res     1
count2                  res     1
count3                  res     1
current_line            res     1
draw_y                  res     1
sprite_x                res     1
sprite_attr             res     1
this_sprite             res     1
scanline_req            res     1
tile                    res     1
mix1                    res     1
mix2                    res     1
r0                      res     1
r1                      res     1
r2                      res     1
r3                      res     1
tile_number             res     1
hub_source              res     1
cog_dest                res     1

'new for Defender
this_sprite_tile        res     1
terrain_ptr             res     1
end_terrain_ptr         res     1
terrain                 res     1
terrain_byte            res     1
p                       res     1
x_tile                  res     1
x_pixel                 res     1
explode_count           res     1
smart_bomb              res     1

                        fit $1e0
              